/*	Renegade Scripts.dll
	SSGM Gamelog scripts
	Copyright 2007 Mac, Jonathan Wilson, Whitedragon(MDB)

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#include <time.h>
#include <fstream>
#include <iostream>
#include "scripts.h"
#include "engine.h"
#include "gmmain.h"
#include "date.h"


void Gamelog_Level_Loaded() {
	if (Settings->NewGamelog) {
		Data->AllowGamelogWrite = true;
		WriteGamelog(StrFormat("2.03;%s",Data->CurrMap));
		WriteGamelog(StrFormat("CONFIG;%u;%ls",The_Game()->TimeLimit_Minutes,The_Game()->GameTitle.Peek_Buffer()));
		Vector3	loc;
		loc.X =	0.0f;
		loc.Y =	0.0f;
		loc.Z =	0.0f;
		GameObject *gamelog_obj	= Commands->Create_Object("Invisible_Object",loc);
		Commands->Attach_Script(gamelog_obj,"Gamelog_Scores","");
	}
	Attach_Script_All_Buildings_Team(2,"Gamelog_Building","",true);
	Attach_Script_All_Turrets_Team(2,"Gamelog_Building","",true);
}

void Gamelog_GameOver(const char* WinType) {
	WriteGamelog(StrFormat("WIN;%ls;%s;%d;%d",Get_Wide_Team_Name(The_Game()->WinnerID),WinType,(int)Get_Team_Score(0),(int)Get_Team_Score(1)));
	if (Settings->NewGamelog) {
		Data->AllowGamelogWrite = false;
		if (Settings->Gamelog_Archive_Logfiles) {
			date logdate;
			logdate.refreshdate();
			time_t rawtime;
			tm *timeinfo;
			time(&rawtime);
			timeinfo = localtime(&rawtime);
			copyfile("./gamelog2.txt",StrFormat("./gamelog_%s_%s_%02d_%02d_%02d.txt",Data->CurrMap,logdate.get_date_string(),timeinfo->tm_hour,timeinfo->tm_min,timeinfo->tm_sec).c_str());
			std::ofstream("gamelog2.txt").write("",0);
		}
		else {
			std::ofstream("gamelog2.txt").write("",0);
		}
	}
}

void Gamelog_ObjectHook(GameObject *obj) {
	if (Is_Vehicle(obj)) {
		if (Get_Vehicle_Mode(obj) != TURRET) {
			Attach_Script_Once(obj,"Gamelog_Vehicle","");
		}
		else {
			Attach_Script_Once(obj,"Gamelog_Building","");
		}
	}
	else if (Commands->Is_A_Star(obj)) {
		Attach_Script_Once(obj,"Gamelog_Soldier","");
	}

	if (Settings->NewGamelog) {
		if (Is_Beacon(obj)) {
			Attach_Script_Once(obj,"Gamelog_Beacon","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"Crate") || strstr(Commands->Get_Preset_Name(obj),"crate")) {
			Attach_Script_Once(obj,"Gamelog_Crate","");
		}
		else if (Is_C4(obj)) {
			Attach_Script_Once(obj,"Gamelog_Mine","");
		}
	}
}


void Gamelog_Scores::NewCreated(GameObject *obj) {
	Commands->Start_Timer(obj,this,60.0f,1);
}

void Gamelog_Scores::Timer_Expired(GameObject *obj,	int	number) {
	if (number == 1) {
		Commands->Start_Timer(obj,this,60.0f,1);
		int	x =	The_Game()->MaxPlayers;
		for	(int j = 1;j <=	x;j++) {
			GameObject *player = Get_GameObj(j);
			if (player) {
				WriteGamelog(StrFormat("SCORE;%d;%d;%d",Commands->Get_ID(player), (int)Commands->Get_Points(player), (int)Commands->Get_Money(player)));
			}
		}
	}
}

void Gamelog_Scores::Custom(GameObject *obj, int message, int param, GameObject	*sender) {
	if (message	== 200) {
		Timer_Expired(obj, 1);
	}
}

void Gamelog_Building::NewCreated(GameObject *obj) {
	Vector3	pos	= Commands->Get_Position(obj);
	WriteGamelog(StrFormat("CREATED;BUILDING;%d;%s;%d;%d;%d;%d;%f;%f;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj),	int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), Commands->Get_Max_Health(obj),Commands->Get_Max_Shield_Strength(obj),Get_Object_Type(obj)));
}

void Gamelog_Building::Destroyed(GameObject	*obj) {
	Vector3	pos	= Commands->Get_Position(obj);
	WriteGamelog(StrFormat("DESTROYED;BUILDING;%d;%s;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y), int(pos.X), int(pos.Z)));
}

void Gamelog_Building::Damaged(GameObject *obj,	GameObject *damager, float damage) {
	if (damage != 0) {
		Vector3	victimpos =	Commands->Get_Position(obj);
		Vector3	damagerpos = Commands->Get_Position(damager);
		WriteGamelog(StrFormat("DAMAGED;BUILDING;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(damager), Commands->Get_Preset_Name(damager), int(damagerpos.Y), int(damagerpos.X),	int(damagerpos.Z), int(Commands->Get_Facing(damager)), damage, int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj)),	int(Commands->Get_Points(obj))));
	}
}

void Gamelog_Building::Killed(GameObject *obj, GameObject *shooter) {
	Vector3	victimpos =	Commands->Get_Position(obj);
	Vector3	damagerpos = Commands->Get_Position(shooter);
	WriteGamelog(StrFormat("KILLED;BUILDING;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%s;%s;%s",Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(shooter),	Commands->Get_Preset_Name(shooter),	int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(shooter)),Get_Current_Weapon(shooter),Get_Preset_Info(obj).c_str(),Get_Preset_Info(shooter).c_str()));
}

void Gamelog_Soldier::Created(GameObject *obj) {
	Vector3	pos	= Commands->Get_Position(obj);
	WriteGamelog(StrFormat("CREATED;SOLDIER;%d;%s;%d;%d;%d;%d;%d;%d;%d;%s", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj),	int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Max_Health(obj)),int(Commands->Get_Max_Shield_Strength(obj)),Commands->Get_Player_Type(obj),Get_Player_Name(obj)));
	Commands->Start_Timer(obj,this,2.0f,1);
}

void Gamelog_Soldier::Destroyed(GameObject *obj) {
	Vector3	pos	= Commands->Get_Position(obj);
	WriteGamelog(StrFormat("DESTROYED;SOLDIER;%d;%s;%d;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj),	int(pos.Y),	int(pos.X),	int(pos.Z),	int(Commands->Get_Points(obj))));
}

void Gamelog_Soldier::Damaged(GameObject *obj, GameObject *damager,	float damage) {
	if (damage != 0) {
		Vector3	victimpos =	Commands->Get_Position(obj);
		Vector3	damagerpos = Commands->Get_Position(damager);
		WriteGamelog(StrFormat("DAMAGED;SOLDIER;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj),	int(victimpos.Y), int(victimpos.X),	int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(damager), Commands->Get_Preset_Name(damager), int(damagerpos.Y),	int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(damager)), damage, int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj)), int(Commands->Get_Points(damager))));
	}
}

void Gamelog_Soldier::Killed(GameObject	*obj, GameObject *shooter) {
	Vector3	victimpos =	Commands->Get_Position(obj);
	Vector3	damagerpos = Commands->Get_Position(shooter);
	WriteGamelog(StrFormat("KILLED;SOLDIER;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%s;%s;%s",Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(shooter),	Commands->Get_Preset_Name(shooter),	int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(shooter)),Get_Current_Weapon(shooter),Get_Preset_Info(obj).c_str(),Get_Preset_Info(shooter).c_str()));
}

void Gamelog_Soldier::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		Commands->Start_Timer(obj,this,2.0f,1);
		Vector3	pos	= Commands->Get_Position(obj);
		WriteGamelog(StrFormat("POS;SOLDIER;%d;%s;%d;%d;%d;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj),	int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj))));
	}
}

void Gamelog_Vehicle::Custom(GameObject	*obj, int message, int param, GameObject *sender) {
	if (message == CUSTOM_EVENT_VEHICLE_ENTER) {
		Vector3	pos	= Commands->Get_Position(obj);
		Vector3	senderpos =	Commands->Get_Position(sender);
		WriteGamelog(StrFormat("ENTER;%d;%s;%d;%d;%d;%d;%s;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj),	int(pos.Y),	int(pos.X),	int(pos.Z),	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), int(senderpos.Y), int(senderpos.X), int(senderpos.Z)));
	}
	else if (message == CUSTOM_EVENT_VEHICLE_EXIT) {
		Vector3	pos	= Commands->Get_Position(obj);
		Vector3	senderpos =	Commands->Get_Position(sender);
		WriteGamelog(StrFormat("EXIT;%d;%s;%d;%d;%d;%d;%s;%d;%d;%d",	Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y), int(pos.X), int(pos.Z), Commands->Get_ID(sender), Commands->Get_Preset_Name(sender),	int(senderpos.Y), int(senderpos.X),	int(senderpos.Z)));
	}
}

void Gamelog_Vehicle::Created(GameObject *obj) {
	Vector3	pos	= Commands->Get_Position(obj);
	WriteGamelog(StrFormat("CREATED;VEHICLE;%d;%s;%d;%d;%d;%d;%d;%d;%d",	Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Max_Health(obj)),int(Commands->Get_Max_Shield_Strength(obj)), Commands->Get_Player_Type(obj)));
	Commands->Start_Timer(obj,this,2.0f,1);
}

void Gamelog_Vehicle::Destroyed(GameObject *obj) {
	Vector3	pos	= Commands->Get_Position(obj);
	WriteGamelog(StrFormat("DESTROYED;VEHICLE;%d;%s;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y), int(pos.X), int(pos.Z)));
}

void Gamelog_Vehicle::Damaged(GameObject *obj, GameObject *damager,	float damage) {
	if (damage != 0) {
		Vector3	victimpos =	Commands->Get_Position(obj);
		Vector3	damagerpos = Commands->Get_Position(damager);
		WriteGamelog(StrFormat("DAMAGED;VEHICLE;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj),	int(victimpos.Y), int(victimpos.X),	int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(damager), Commands->Get_Preset_Name(damager), int(damagerpos.Y),	int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(damager)), damage, int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj)), int(Commands->Get_Points(damager))));
	}
}

void Gamelog_Vehicle::Killed(GameObject	*obj, GameObject *shooter) {
	Vector3	victimpos =	Commands->Get_Position(obj);
	Vector3	damagerpos = Commands->Get_Position(shooter);
	WriteGamelog(StrFormat("KILLED;VEHICLE;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%s;%s;%s",Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(shooter),	Commands->Get_Preset_Name(shooter),	int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(shooter)),Get_Current_Weapon(shooter),Get_Preset_Info(obj).c_str(),Get_Preset_Info(shooter).c_str()));
}

void Gamelog_Vehicle::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		Commands->Start_Timer(obj,this,2.0f,1);
		Vector3	pos	= Commands->Get_Position(obj);
		WriteGamelog(StrFormat("POS;VEHICLE;%d;%s;%d;%d;%d;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj),	int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj))));
	}
}

void Gamelog_Mine::Created(GameObject *obj) {
	Vector3 pos = Commands->Get_Position(obj);
	WriteGamelog(StrFormat("CREATED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Max_Health(obj)), int(Commands->Get_Max_Shield_Strength(obj)), Get_Object_Type(obj),Commands->Get_ID(Get_C4_Planter(obj))));
}

void Gamelog_Mine::Destroyed(GameObject	*obj) {
	Vector3	pos = Commands->Get_Position(obj);
	if (!WasDisarmed && Is_Script_Attached(obj,"MDB_SSGM_C4_Detonation")) {
		WriteGamelog(StrFormat("DETONATED;OBJECT;%d;%s;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y), int(pos.X), int(pos.Z)));
	}
	WriteGamelog(StrFormat("DESTROYED;OBJECT;%d;%s;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y), int(pos.X), int(pos.Z)));
}

void Gamelog_Mine::Damaged(GameObject *obj, GameObject *damager, float damage) {
	if (damage != 0) {
		Vector3	victimpos =	Commands->Get_Position(obj);
		Vector3	damagerpos = Commands->Get_Position(damager);
		WriteGamelog(StrFormat("DAMAGED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y),	int(victimpos.X), int(victimpos.Z),	int(Commands->Get_Facing(obj)),	Commands->Get_ID(damager), Commands->Get_Preset_Name(damager), int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z),	int(Commands->Get_Facing(damager)),	damage,	int(Commands->Get_Health(obj)),	int(Commands->Get_Shield_Strength(obj))));
	}
}

void Gamelog_Mine::Killed(GameObject *obj, GameObject *shooter) {
	WasDisarmed = true;
	Vector3	victimpos =	Commands->Get_Position(obj);
	Vector3	damagerpos = Commands->Get_Position(shooter);
	WriteGamelog(StrFormat("KILLED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%s;%s;%s",Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(shooter),	Commands->Get_Preset_Name(shooter),	int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(shooter)),Get_Current_Weapon(shooter),Get_Preset_Info(obj).c_str(),Get_Preset_Info(shooter).c_str()));
}

void Gamelog_Beacon::Created(GameObject	*obj) {
	Vector3	pos	= Commands->Get_Position(obj);
	WriteGamelog(StrFormat("CREATED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y),int(pos.X),int(pos.Z),	int(Commands->Get_Facing(obj)),	int(Commands->Get_Max_Health(obj)),int(Commands->Get_Max_Shield_Strength(obj)),	Commands->Get_Player_Type(obj),Commands->Get_ID(Get_Beacon_Planter(obj))));
}

void Gamelog_Beacon::Destroyed(GameObject *obj) {
	Vector3	pos	= Commands->Get_Position(obj);
	WriteGamelog(StrFormat("DESTROYED;OBJECT;%d;%s;%d;%d;%d", Commands->Get_ID(obj),Commands->Get_Preset_Name(obj), int(pos.Y), int(pos.X), int(pos.Z)));
}

void Gamelog_Beacon::Damaged(GameObject	*obj, GameObject *damager, float damage) {
	if (damage != 0) {
		Vector3	victimpos =	Commands->Get_Position(obj);
		Vector3	damagerpos = Commands->Get_Position(damager);
		WriteGamelog(StrFormat("DAMAGED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj),	int(victimpos.Y), int(victimpos.X),	int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(damager), Commands->Get_Preset_Name(damager), int(damagerpos.Y),	int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(damager)), damage, int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj))));
	}
}

void Gamelog_Beacon::Killed(GameObject *obj, GameObject	*shooter) {
	Vector3	victimpos =	Commands->Get_Position(obj);
	Vector3	damagerpos = Commands->Get_Position(shooter);
	WriteGamelog(StrFormat("KILLED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%s;%s;%s",Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(shooter),	Commands->Get_Preset_Name(shooter),	int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(shooter)),Get_Current_Weapon(shooter),Get_Preset_Info(obj).c_str(),Get_Preset_Info(shooter).c_str()));
}

void Gamelog_Chat_Hook(int PlayerID, int Type, const wchar_t *Message) {
	GameObject *player = Get_GameObj(PlayerID);
	char type[8];
	if (Type ==	0) {
		sprintf(type,"PUBLIC");
	}
	else if (Type == 1) {
		sprintf(type,"TEAM");
	}
#ifdef WIN32
	WriteGamelog(StrFormat("CHAT;%s;%d;%ls", type, Commands->Get_ID(player), Message));
#else
	WriteGamelog(StrFormat("CHAT;%s;%d;%ls", type, Commands->Get_ID(player), Message));
#endif
}

void Gamelog_Crate::Created(GameObject *obj) {
	Vector3	pos	= Commands->Get_Position(obj);
	WriteGamelog(StrFormat("CREATED;CRATE;%d;%s;%d;%d;%d;%d;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Max_Health(obj)),int(Commands->Get_Max_Shield_Strength(obj)), int(Commands->Get_Player_Type(obj))));
}

void Gamelog_Crate::Destroyed(GameObject *obj) {
	Vector3	pos	= Commands->Get_Position(obj);
	WriteGamelog(StrFormat("DESTROYED;CRATE;%d;%s;%d;%d;%d",	Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y), int(pos.X), int(pos.Z)));
}

void Gamelog_Crate::Damaged(GameObject *obj, GameObject	*damager, float	damage) {
	if (damage != 0) {
		Vector3	victimpos =	Commands->Get_Position(obj);
		Vector3	damagerpos = Commands->Get_Position(damager);;
		WriteGamelog(StrFormat("DAMAGED;CRATE;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d",	Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(damager),	Commands->Get_Preset_Name(damager),	int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z),int(Commands->Get_Facing(damager)),	damage,	int(Commands->Get_Health(obj)),	int(Commands->Get_Shield_Strength(obj))));
	}
}

void Gamelog_Crate::Killed(GameObject *obj,	GameObject *shooter) {
	Vector3	victimpos =	Commands->Get_Position(obj);
	Vector3	damagerpos = Commands->Get_Position(shooter);
	WriteGamelog(StrFormat("KILLED;CRATE;%d;%s;%d;%d;%d;%d;%d;%s;%f;%f;%f;%f;%s;%s;%s",Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(shooter),	Commands->Get_Preset_Name(shooter),	int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(shooter)),Get_Current_Weapon(shooter),Get_Preset_Info(obj).c_str(),Get_Preset_Info(shooter).c_str()));
}

ScriptRegistrant<Gamelog_Building> Gamelog_Building_Registrant("Gamelog_Building","");
ScriptRegistrant<Gamelog_Soldier> Gamelog_Soldier_Registrant("Gamelog_Soldier","");
ScriptRegistrant<Gamelog_Vehicle> Gamelog_Vehicle_Registrant("Gamelog_Vehicle","");
ScriptRegistrant<Gamelog_Mine> Gamelog_Mine_Registrant("Gamelog_Mine","");
ScriptRegistrant<Gamelog_Beacon> Gamelog_Beacon_Registrant("Gamelog_Beacon","");
ScriptRegistrant<Gamelog_Crate>	Gamelog_Crate_Registrant("Gamelog_Crate","");
ScriptRegistrant<Gamelog_Scores> Gamelog_Scores_Registrant("Gamelog_Scores","");
